/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.actions.breakpoints;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.actions.breakpoints.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorPart;
import org2.eclipse.php.internal.debug.ui.breakpoint.provider.PHPBreakpointProvider;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) throws CoreException {
        Job job = new Job(Messages.ToggleBreakpointAdapter_toggleBreakpointJobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    EditorPart editorPart = (EditorPart)part;
                    IEditorInput editorInput = editorPart.getEditorInput();
                    TextSelection rs = (TextSelection)selection;
                    try {
                        AbstractThemeableEditor unifiedEditor = (AbstractThemeableEditor)editorPart;
                        new PHPBreakpointProvider().addBreakpoint(unifiedEditor, editorInput, rs.getStartLine(), rs.getOffset());
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)PHPDebugEPLPlugin.getDefault(), (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

